-- Not used by Autodesk MassFX: no localization.

-- PhysX utilities and exporter
try( removerollout px_utility) catch()

utility px_utility "PhysX Plugin" rolledUp:true
(
	timer   simClock  "simulationClock" interval:1 active:false
	-- quitMaxClock is for batch exporting
	timer   quitMaxClock  "delayQuitMax" interval:100 active:false
	
	button  bt_export                       "Export"     tooltip:"Export PhysX scene" across:2
  	button  bt_about                        "About"      tooltip:"Show version information and credits"
  	
  	on bt_export pressed do
  	(
  		global PxExportPxProj_Prompting
  		PxExportPxProj_Prompting(false)
  	)
  	
  	on bt_about pressed do
  	(
  		nvpx.ShowAboutDialog()
  	)

	
	local   lastTime = 0;
	on simClock tick do 
	(
		simClock.active = false
		if animButtonState then	animButtonState = false
	
		tDelta = 1000.0/(frameRate); 
		
		--DETERMINE BURN TIME IF SIMULATING TOO LAST--		
		tStart = timeStamp()
		tEnd = lastTime + tDelta
		if (tEnd > tStart) then
		(
			while timeStamp() < tEnd do
			(
			)
		)
		lastTime = tEnd
		if(lastTime < tStart) then lastTime = tStart
		
		--SIMULATE--
		
		with redraw off 
		(
			undo off
			(
				try
				(
					PxSimulateOneFrame(); 
				) catch ()
			)
		)
		
		redrawviews();

		
		simClock.active = true
		
		if (sliderTime >= animationRange.end) then
		(	
			case gPxOnLastFrame of
			(
				1: slidertime = animationRange.end
				2: PxPauseSimulation()
				3: if gPxLoopAnimation == 1 then (PxStopSimulation(); PxRunSimulation()) else sliderTime = animationRange.start
			)
		)	
	)
	
	on quitMaxClock tick do
	(
		quitMaxClock.active = false
		quitMAX #noPrompt
	)
)

fn PxCheckViewer = 
(
	if (nvpx.ShouldViewerSync()) do
	(
		PxShowViewer()
	)

	-- 
	local vcommand = nvpx.GetViewerCommand()
	if(vcommand == 1) do
	(
		nvpx.SetViewerCommand(0);   -- clear flag to prevent repeat
		PxShowPhysicsPanel(1);      -- see also: VIEWERCOMMAND_SHOW_PHYSXPANEL
		setFocus px_physXPanel
	)
	
	if(vcommand == 2) do            -- restart viewer
	(
		nvpx.SetViewerCommand(0);   -- clear flag to prevent repeat
		PxShowViewer()
	)
	
	nvpx.CheckViewerState()
)

fn PxStartViewerClock = 
(
	global gViewerClock
	gViewerClock.Enabled = true
)

fn PxStopViewerClock = 
(
	global gViewerClock
	gViewerClock.Enabled = false
)

global gViewerClock = dotNetObject "System.Windows.Forms.Timer" 
dotnet.addEventHandler  gViewerClock "tick" PxCheckViewer
gViewerClock.interval = 500
gViewerClock.Enabled = false



